local function make_pillar(n, base)
  base = base or Vector.new(0, 0)
  local ret = {}
  for i = 0, n - 1 do
    table.insert(ret, Place.new(CellView.new(Vector.new(0, i) + base), Basic.new(1)))
  end
  for i = 1, n - 1 do
    table.insert(ret, Join.new(CellFace.new(Vector.new(0, i) + base, DOWN)))
  end
  return ret
end
local function make_seq(s)
  local ret = {}
  for i = 1, 5 do
    for _, v in pairs(make_pillar(s[i], Vector.new(i - 1, 0))) do
      table.insert(ret, v)
    end
  end
  return ret
end
location.std.generators[1].dynamic = function(ct)
  return make_seq(get_seq(ct))
end
local output_getter = coroutine.wrap(function()
  while true do
    for i = 1, 5 do
      coroutine.yield(make_pillar(i))
    end
  end
end)
location.std.checkers[1].dynamic = function(ct)
  return output_getter()
end

local generate_sequence = {{3, 1, 2, 5, 4}, {5, 2, 1, 3, 4}, {4, 2, 5, 3, 1}, {5, 3, 2, 1, 4}, {1, 4, 5, 3, 2}, {5, 4, 2, 3, 1}, {5, 1, 2, 4, 3}, {4, 1, 5, 2, 3}, {1, 4, 5, 3, 2}, {2, 4, 5, 1, 3}, {3, 1, 2, 5, 4}, {1, 5, 4, 3, 2}, {3, 1, 4, 2, 5}, {1, 4, 2, 5, 3}, {4, 3, 2, 1, 5}, {4, 1, 2, 3, 5}, {2, 5, 4, 1, 3}, {2, 4, 5, 3, 1}, {5, 3, 1, 2, 4}, {4, 1, 5, 2, 3}, {5, 2, 3, 4, 1}, {3, 5, 2, 4, 1}, {5, 3, 2, 4, 1}, {5, 2, 3, 4, 1}, {1, 5, 2, 4, 3}, {2, 5, 1, 4, 3}, {3, 1, 2, 5, 4}, {2, 4, 3, 1, 5}, {4, 3, 5, 2, 1}, {5, 4, 2, 1, 3}, {2, 3, 5, 4, 1}, {4, 5, 1, 3, 2}, {4, 5, 1, 3, 2}, {5, 2, 3, 4, 1}, {5, 2, 4, 1, 3}, {3, 2, 1, 4, 5}, {2, 4, 1, 5, 3}, {2, 4, 3, 1, 5}, {2, 3, 5, 1, 4}, {2, 1, 4, 5, 3}, {2, 5, 1, 4, 3}, {1, 3, 5, 4, 2}, {4, 2, 3, 1, 5}, {3, 5, 1, 2, 4}, {3, 2, 5, 4, 1}, {2, 3, 4, 1, 5}, {4, 2, 1, 5, 3}, {5, 3, 1, 4, 2}, {4, 1, 2, 5, 3}, {5, 3, 2, 4, 1}}

function get_seq(idx)
  return generate_sequence[(idx % #generate_sequence) + 1]
end
